%x agentclass field rectangle attr display rule routine code view statistics

%{
#include <string.h>
#include "agent.h"
#include "attribute.h"
#include "routine_composite.h"
#include "conf_reader.h"

int code_toggle=0;

long current_line=0;
long current_char=0;
int input_string=0;
char *input_data=NULL;
long input_ptr=0;

/* disable output */

#define ECHO

#define YY_INPUT(buf,result,max_size) \
               { \
               int c; \
	       if(input_string){\
	       		c=input_data[input_ptr];\
			if(c)input_ptr++;\
			if(!c)c=EOF;\
			} else\
		       c = fgetc(yyin); \
               result = (c == EOF) ? YY_NULL : (buf[0] = c, 1); \
	       current_char++; \
	       if(c=='\n'){ \
	       		current_line++; \
			current_char=0; \
			} \
               }
 
int yywrap(void)
{
return 1;
}


void reset_lex(void)
{
BEGIN(INITIAL);
}

%}



%%

agentclass	{ 
		BEGIN(agentclass);
		return T_AGENTCLASS;
		}

<statistics,view,attr,routine,agentclass,field,rule>[\"][^\"]*[\"]		{
		yylval.string=strdup(yytext+1);
		yylval.string[strlen(yylval.string)-1]=0;
		return T_STRING;
		}

<INITIAL,statistics,view,routine,attr,rule,agentclass,field>([' ']|\n|\t|\(|\)|,)+		{
		return T_WHITESPACE;
		}

<attr,routine,view,statistics,rule,agentclass,field>end		{
		BEGIN(INITIAL);
		return T_END;
		}

<agentclass>set		{
		yylval.value=ATTR_SET;
		return T_TYPE;
		}
		
<agentclass>int		{
		yylval.value=ATTR_INT;
 		return T_TYPE;
		}
		
<agentclass>bool	{
		yylval.value=ATTR_BOOL;
		return T_TYPE;		
		}

<agentclass>rand_set		{
		yylval.value=ATTR_SET|ATTR_RANDOM;
		return T_TYPE;
		}
		
<agentclass>rand_int		{
		yylval.value=ATTR_INT|ATTR_RANDOM;
 		return T_TYPE;
		}
		
<agentclass>rand_bool	{
		yylval.value=ATTR_BOOL|ATTR_RANDOM;
		return T_TYPE;		
		}

<agentclass>attribute	{
		return T_ATTRIBUTE;
		}
		
<agentclass>size	{
		return T_SIZE;
		}
		
<agentclass>random	{
		return T_RANDOM;
		}
		

<INITIAL,routine,attr,agentclass,field,rectangle,statistics>[0123456789]+	{
		yylval.value=atol(yytext);
		return T_VALUE;
		}
			
<INITIAL,routine,attr,agentclass,field,rectangle>-[0123456789]+	{
		yylval.value=atol(yytext);			
		return T_VALUE;
		}

<INITIAL,routine,attr,agentclass,field,rectangle>false	{
		yylval.value=0;			
		return T_VALUE;
		}

<INITIAL,routine,attr,agentclass,field,rectangle>true	{
		yylval.value=1;			
		return T_VALUE;
		}

<INITIAL,routine,attr,agentclass,field,rectangle>all	{
		return T_ALL;
		}

field		{
		BEGIN(field);
		return T_FIELD;
		}

<field>dimensions	{ /* ok it's a spelling error */
			return T_DIMENSIONS;
			}

<field>dimentions	{
			return T_DIMENSIONS;
			}

<field>paint		{
			return T_PAINT;
			}
			
<field>rect		{
			BEGIN(rectangle);
			return T_RECT;
			}			

<field>circle		{
			BEGIN(rectangle);
			return T_CIRCLE;
			}			

<rectangle>[\(, ]*	{ /* do nothing */
			}

<rectangle>\)		{
			BEGIN(field);
			}

time			{
			return T_TIME;
			}


attribute		{
			BEGIN(attr);
			return T_ATTRIBUTE;
			}
			
<attr>type		{
			return T_TYPE;
			}
			
<attr>default		{
			return T_DEFAULT;
			}
			
		
<attr>bool		{
			return T_BOOL;
			}
			
<attr>int		{
			return T_INT;
			}

<attr>set		{
			return T_SET;
			}
			
<attr>repertoire	{
			return T_REPERTOIRE;
			}			
			
<attr>smallest	{
			return T_SMALLEST;
			}
			
<attr>largest	{
			return T_LARGEST;
			}
			
<attr>size		{
			return T_SIZE;
			}																

<attr>bias_min		{
			return T_BIAS_MIN;
			}																

<attr>bias_vol		{
			return T_BIAS_VOL;
			}																

<attr>walk		{
			return T_WALK;
			}

<attr>jump		{
			return T_JUMP;
			}
						
<attr>bias_max		{
			return T_BIAS_MAX;
			}																


<attr>empty		{
			yylval.value=0;
			return T_VALUE;
			}

display			{
			BEGIN(display);
			}

<display>end		{
			BEGIN(INITIAL);
			}

<display>.		{}			

rule			{
			BEGIN(rule);
			return T_RULE;
			}

<rule>condition		{
			return T_CONDITION;
			}
			
<rule>attribute		{
			return T_ATTRIBUTE;
			}			

<rule>becomes		{
			return T_BECOMES;
			}
			
routine			{
			BEGIN(routine);
			return T_ROUTINE;
			}


<routine>from		{
			return T_FROM;
			}
				
<routine>parameters	{
			return T_PARAMETERS;
			}				

<routine,view>comment	{
			return T_COMMENT;
			}
			
<routine>composite	{
			return T_COMPOSITE;
			}
			
<routine>code		{
			BEGIN(code);
			code_toggle=0;
			return T_CODE;
			}
			
<code>\"		{
			code_toggle++;
			if(code_toggle>1)BEGIN(routine);
			}

<code>\*		{
			yylval.value=OPT_MUL;
			return T_OPT2;
			}
			
<code>\+		{
			yylval.value=OPT_ADD;
			return T_OPT2;
			}
			
<code>\-		{
			yylval.value=OPT_SUB;
			return T_OPT2;
			}
			
<code>\/		{
			yylval.value=OPT_DIV;
			return T_OPT2;
			}
			
<code>\(		{
			return T_LPARAN;
			}
			
<code>\)		{
			return T_RPARAN;
			}


<code>\?		{
			return T_QM;
			}
			
<code>\:		{
			return T_COLON;
			}			
			
<code>[0123456789]+	{
			yylval.value=atol(yytext);
			return T_VALUE;
			}
			
<routine,code>\[[^\]]*\]	{
			yylval.string=strdup(yytext+1);
			yylval.string[strlen(yylval.string)-1]=0;
			return T_AT;		
			}			
			
<routine,code>\{[^\}]*\}	{
			yylval.string=strdup(yytext+1);
			yylval.string[strlen(yylval.string)-1]=0;
			return T_FN;		
			}			
			
<code>and		{
			yylval.value=OPT_AND;
			return T_OPT2;
			}
			
<code>or		{
			yylval.value=OPT_OR;
			return T_OPT2;
			}
			
<code>\<=		{
			yylval.value=OPT_LE;
			return T_OPT2;
			}

<code>\>=		{
			yylval.value=OPT_GE;
			return T_OPT2;
			}

<code>==		{
			yylval.value=OPT_EQL;
			return T_OPT2;
			}

<code>\<		{
			yylval.value=OPT_LT;
			return T_OPT2;
			}
			
<code>\>		{
			yylval.value=OPT_GT;
			return T_OPT2;
			}

			
			
<code>\  		{ /* ignore spaces */  }									


view			{
			BEGIN(view);
			return T_VIEW;
			}

<view>type		{
			return T_TYPE;
			}
			
<view>color1		{
			return T_COLOR1;
			}
			
<view>color2		{
			return T_COLOR2;
			}
			
<view>color3		{
			return T_COLOR3;
			}


statistics		{
			BEGIN(statistics);
			return T_STATISTICS;
			}

<statistics>file	{
			return T_FILE;
			}			

<statistics>bias	{
			return T_BIAS;
			}
			
<statistics>sum		{
			return T_SUM;
			}
			
<statistics>distribution {
			  return T_DISTRIBUTION;
			  }						
			
EOF		return 0;

%%

